<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class FixUsers extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        $users = Users::query()->where('status', 0)->whereNotNull('api_id')->get();

        foreach ($users as $user) {
            $bridge->contentUpdate('users', [
                'uuid' => $user->uuid,
                'api_id' => null
            ]);
        }
        DB::table('inside_user_provider_references')->truncate();
    }

    public function down(): void
    {
    }
}
