<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class ReconfigurePhoneField extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__, 'users_phone');

        $this->getBridge()->contentTypeUpdateField(
            'users',
            'phone',
            [
                'name'                => 'phone',
                'searchable'          => true,
                'translatable'        => false,
                'default'             => '',
                'searchable_filter'   => false,
                'search_result_field' => true,
                'required'            => false,
                'weight'              => 7,
                'title'               => [
                    'fr' => 'Téléphone du service',
                ],
                'description'         => [
                    'fr' => '',
                ],
                'placeholder' => [
                    'fr' => '',
                ],
                'widget'              => [
                    'type'     => BridgeContentType::INSIDE_PHONE_WIDGET,
                    'settings' => [
                        'size'                => 60,
                        'placeholder'         => '',
                        'short_number_length' => 4,
                    ],
                    'weight'   => 7,
                ],
                'type'                => BridgeContentType::TEXT_FIELD,
                'settings'            => [
                    'max_length'     => 91,
                    'is_ascii'       => false,
                    'case_sensitive' => false,
                    'cardinality'    => 1,
                ],
            ]
        );

        $this->finishUp();
    }

    public function down(): void
    {
    }
}
