<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class EditServicesSpacesRelatedContentTypes extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'services_content',
            'display_as_cta',
            [
                'name' => 'display_as_cta',
                'searchable' => false,
                'translatable' => false,
                'default' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 9,
                'title' => [
                    'fr' => 'Afficher en forme de CTA'
                ],
                'description' => [
                    'fr' => 'Si le bouton radio est coché le contenu s\'affichera dans un encadré'
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            9
        );

        $bridge->contentTypeCreateOrUpdateField(
            'services_content',
            'services_space',
            [
                'name' => 'services_space',
                'type' => BridgeContentType::REFERENCE_FIELD,
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 10,
                'title' => [
                    'fr' => 'Espace service concerné',
                ],
                'description' => [
                    'fr' => 'Sélectionnez l\'espace service où faire remonter cette page'
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                ],
                'settings' => [
                    'cardinality' => 1,
                    'target_type' => ['services_space'],
                ],
            ],
            10
        );

        $bridge->contentTypeDeleteField('node', 'services_space', 'parent_services_space');
    }

    public function down(): void
    {
    }
}
