<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\Users;
use Inside\Content\Models\Contents\UsersFunctions;
use Inside\Host\Bridge\BridgeContent;

class ReplaceFunctionField extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    protected function createUserFunctions(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('users_functions');
        $this->migrateContent('users');

        $this->finishUp();
        Artisan::call("models:rebuild");
    }

    public function up(): void
    {
        $bridge = new BridgeContent();
        $users = Users::select(['uuid', 'function'])->where('function', '!=', null)->get();
        $this->createUserFunctions();
        foreach ($users as $user) {
            $function = $user->function;
            $userFunction = UsersFunctions::where('title', $function)->first();
            if (!$userFunction) {
                $uuid = $bridge->contentInsert('users_functions', [
                    'title' => $function,
                    'type' => 'node',
                    'bundle' => 'users_functions'
                ]);
            } else {
                $uuid = $userFunction->uuid;
            }
            $bridge->contentUpdate('users', [
                'uuid' => $user->uuid,
                'users_functions' => $uuid
            ]);
        }
    }

    public function down(): void
    {
    }
}
