<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddFieldsToNeedsPage extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'needs_page',
            'link',
            [
                'name' => 'link',
                'type' => BridgeContentType::LINK_FIELD,
                'searchable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 4,
                'title' => [
                    'fr' => 'Lien',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [],
                    'weight' => 1,
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            4
        );

        $bridge->contentTypeCreateOrUpdateField(
            'needs_page',
            'is_modale',
            [
                'name' => 'is_modale',
                'searchable' => false,
                'translatable' => false,
                'default' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 5,
                'title' => [
                    'fr' => 'Afficher dans une modale ?'
                ],
                'description' => [
                    'fr' => ''
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'group' => 'group_advanced_options',
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            5
        );
    }

    public function down(): void
    {
    }
}
