<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class ParagraphUser extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $contents = ['news', 'to_know', 'events', 'tools', 'pages'];
        foreach ($contents as $content) {
            $bridge->contentTypeCreateOrUpdateField(
                $content,
                'content',
                [
                    'name' => 'content',
                    'title' => [
                        'fr' => 'Contenu',
                    ],
                    'widget' => [
                        'type' => BridgeContentType::SECTION_WIDGET,
                        'settings' => [
                            'title' => 'Paragraph',
                            'title_plural' => 'Paragraphs',
                            'edit_mode' => 'closed',
                            'add_mode' => 'dropdown',
                            'form_display_mode' => 'default',
                            'default_paragraph_type' => '_none',
                        ],
                    ],
                    'type' => BridgeContentType::SECTION_FIELD,
                    'settings' => [
                        'target_type' => ['text', 'image', 'text_with_image', 'file', 'slider', 'accordion', 'call_to_action', 'video', 'html', 'map', 'user_cards'],
                        'cardinality' => -1,
                    ],
                ]
            );
        }
    }

    public function down(): void
    {
    }
}
