<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddFieldsForUsers extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'dect',
            [
                'name' => 'dect',
                'type' => BridgeContentType::TEXT_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 1,
                'title' => [
                    'fr' => 'DECT',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            1
        );

        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'locations',
            [
                'name' => 'locations',
                'type' => BridgeContentType::TEXT_FIELD,
                'searchable' => false,
                'translatable' => false,
                'required' => false,
                'weight' => 2,
                'title' => [
                    'fr' => 'Emplacement',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            2
        );
        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'languages',
            [
                'name' => 'languages',
                'type' => BridgeContentType::TEXT_FIELD,
                'searchable' => false,
                'translatable' => false,
                'required' => false,
                'weight' => 3,
                'title' => [
                    'fr' => 'Langues',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            3
        );
        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'fax',
            [
                'name' => 'fax',
                'type' => BridgeContentType::TEXT_FIELD,
                'searchable' => false,
                'translatable' => false,
                'required' => false,
                'weight' => 4,
                'title' => [
                    'fr' => 'Fax',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            4
        );

        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'referent',
            [
                'name' => 'referent',
                'type' => BridgeContentType::TEXT_FIELD,
                'searchable' => false,
                'translatable' => false,
                'required' => false,
                'weight' => 5,
                'title' => [
                    'fr' => 'Référent',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            5
        );
    }

    public function down(): void
    {
    }
}
