<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class DeleteUselessPushNotifications extends Migration
{
    public function up(): void
    {
        NotificationType::query()->whereIn('via', ['push_mobile', 'push_desktop'])
            ->where(function ($query) {
                $query->where('condition', 'is_featured:1|status:1')
                ->orWhere('type', 'group')
                ->orWhere('action', 'commentCommented')
                ;
            })
            ->delete();
    }

    public function down(): void
    {
    }
}
