<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddGenericAccountFieldToUsers extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'generic_account',
            [
                'name' => 'generic_account',
                'searchable' => false,
                'translatable' => false,
                'default' => false,
                'search_result_field' => false,
                'searchable_filter' => true,
                'required' => false,
                'editable' => false,
                'weight' => 10,
                'title' => [
                    'fr' => 'Compte générique'
                ],
                'description' => [
                    'fr' => ''
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'group' => 'group_advanced_options',
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            10
        );
    }

    public function down(): void
    {
    }
}
