<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class HandleMobileField extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('user', 'user', 'mobile');
        $bridge->contentTypeCreateField(
            'users',
            'mobile',
            [
                'name' => 'mobile',
                'type' => BridgeContentType::TEXT_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 6,
                'title' => [
                    'fr' => 'Mobile',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'group' => 'group_contact'
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            5
        );

        // messed up the field in csv import
        \Inside\Content\Models\Contents\Users::each(function ($user) {
            if ($user->phone) {
                $user->mobile = $user->phone;
                $user->phone = null;
                $user->save();
            }
        });
    }

    public function down(): void
    {
    }
}
