<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddServiceAndSiteToUsers extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('specialties');
        $this->finishUp();


        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'structures',
            [
                'name' => 'structures',
                'type' => BridgeContentType::REFERENCE_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => true,
                'searchable_filter' => true,
                'required' => true,
                'weight' => 8,
                'title' => [
                    'fr' => 'Site',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                ],
                'settings' => [
                    'cardinality' => 1,
                    'target_type' => ['structure'],
                ],
            ],
            8
        );

        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'specialties',
            [
                'name' => 'specialties',
                'type' => BridgeContentType::REFERENCE_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => true,
                'searchable_filter' => true,
                'required' => false,
                'weight' => 9,
                'title' => [
                    'fr' => 'Spécialité',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                ],
                'settings' => [
                    'cardinality' => 1,
                    'target_type' => ['specialties'],
                ],
            ],
            9
        );

        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'services',
            [
                'name' => 'services',
                'type' => BridgeContentType::REFERENCE_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => true,
                'searchable_filter' => true,
                'required' => false,
                'weight' => 10,
                'title' => [
                    'fr' => 'Services',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                ],
                'settings' => [
                    'target_type' => ['services'],
                    'cardinality' => 1,
                ],
            ],
            10
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        //
    }
}
