<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'content',
        'name' => 'services_tabs',
        'title' => [
            'fr' => 'Onglet service',
        ],
    ],
    'fields' => [
        [
            'name' => 'order',
            'type' => BridgeContentType::INTEGER_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Ordre',
            ],
            'description' => [
                'fr' => 'Intégrez une valeur chiffrée, la plus petite remontant en 1re position'
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'services_space',
            'searchable' => false,
            'translatable' => false,
            'default' => null,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Espace service concerné'
            ],
            'description' => [
                'fr' => 'Sélectionnez l\'espace service où faire remonter cette page',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => $weight++,
                'group' => 'group_options',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['services_space'],
                'cardinality' => 1,
            ],
        ],
    ],
];
