<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Structure;
use Inside\Host\Bridge\BridgeContent;

class UpdateStructuresTitles extends Migration
{
    public function up(): void
    {
        $titlesMapping = [
            'HPSJ' => 'Hôpital Paris Saint-Joseph',
            'HML' => 'Hôpital Marie-Lannelongue',
            'Groupe' => 'Hôpitaux Saint-Joseph Marie-Lannelongue',
            'CMT' => 'Centres de Santé Marie-Thérèse',
        ];

        $bridge = new BridgeContent();
        collect($titlesMapping)->each(function (string $newTitle, string $key) use ($bridge) {
            $structure = Structure::where('title', $key)->first();
            if ($structure) {
                $bridge->contentUpdate('structure', [
                    'uuid' => $structure->uuid,
                    'title' => $newTitle
                ]);
            }
        });
    }
}
