<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Notify\Models\NotificationType;

final class RemoveNewsNotifyField extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeDeleteField('node', 'news', 'notify');
        $this->finishUp();

        NotificationType::query()
            ->where('model', 'Inside\\Content\\Models\\Contents\\News')
            ->where('event', 'Inside\Content\Events\ContentCreatedEvent')
            ->where('type', 'global')
            ->where('action', 'create')
            ->where('condition', 'notify:1|status:1')
            ->delete();
    }
}
