<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Services;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class UpdateServicesContents extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();
        $services = Services::all();

        foreach ($services as $service) {
            $bridge->contentUpdate('services', [
                'uuid' => $service->uuid,
                'is_hidden' => $service->is_hidden ?? 0
            ]);
        }
    }
}
