<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddSamaccountnameFieldToUsers extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateField(
            'users',
            'samaccountname',
            [
                'name' => 'samaccountname',
                'type' => BridgeContentType::TEXT_FIELD,
                'editable' => true,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 15,
                'title' => [
                    'fr' => 'SamAccountName',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'hidden' => true,
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
