<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddFetchedContentsToContentFields extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $infos = [
            "news" => [
                "weight" => 3,
                "extra" => []
            ],
            "services_presentation" => [
                "weight" => 2,
                "extra" => ["button", "files"]
            ],
            "needs_page" => [
                "weight" => -4,
                "extra" => ["button", "files"]
            ],
            "to_know" => [
                "weight" => 121,
                "extra" => []
            ],
            "info_content" => [
                "weight" => -3,
                "extra" => ["button", "files"]
            ],
            "services_content" => [
                "weight" => -2,
                "extra" => ["button", "files"]
            ],
            "events" => [
                "weight" => 102,
                "extra" => ["button"]
            ],
            "pages" => [
                "weight" => 121,
                "extra" => ["button"]
            ]
        ];

        $types = ["news", "services_presentation", "needs_page", "to_know", "info_content", "services_content", "events", "pages"];

        foreach ($types as $type) {
            $bridge->contentTypeCreateOrUpdateField(
                $type,
                'content',
                [
                    'name' => 'content',
                    'searchable' => true,
                    'translatable' => false,
                    'search_result_field' => false,
                    'required' => false,
                    'weight' => $infos[$type]['weight'],
                    'title' => [
                        'fr' => 'Contenu',
                    ],
                    'widget' => [
                        'type' => BridgeContentType::SECTION_WIDGET,
                        'settings' => [
                            'title' => 'Paragraphe',
                            'title_plural' => 'Paragraphes',
                            'edit_mode' => 'open',
                            'add_mode' => 'dropdown',
                            'form_display_mode' => 'default',
                            'default_paragraph_type' => '',
                        ],
                    ],
                    'type' => BridgeContentType::SECTION_FIELD,
                    'settings' => [
                        'target_type' => array_merge(
                            ['text', 'text_with_image', 'image', 'file', 'slider', 'accordion',
                            'call_to_action', 'fetched_contents', 'video', 'html', 'map', 'user_cards'],
                            $infos[$type]["extra"]
                        ),
                        'cardinality' => -1,
                    ],
                ],
                $infos[$type]['weight']
            );
        }
    }

    public function down(): void
    {
    }
}
