<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddInfoFlashFieldToNews extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'news',
            'flash_info',
            [
                'name' => 'info_flash',
                'searchable' => false,
                'translatable' => false,
                'default' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 7,
                'title' => [
                    'fr' => 'Flash info'
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'group' => 'group_advanced_options',
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            7
        );
    }

    public function down(): void
    {
    }
}
