<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\ServicesPresentation;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class EditServicesPresentationContentType extends Migration
{
    protected function replaceField(BridgeContentType $bridge): void
    {
        $bridge->contentTypeDeleteField('node', 'services_presentation', 'summary');
        $bridge->contentTypeCreateField(
            'services_presentation',
            'summary',
            [
                'name'                => 'summary',
                'searchable'          => false,
                'translatable'        => false,
                'default'             => false,
                'search_result_field' => false,
                'required'            => false,
                'weight'              => 1,
                'title'               => [
                    'fr' => 'Résumé',
                ],
                'description'         => [
                    'fr' => '',
                ],
                'widget'              => [
                    'type'      => BridgeContentType::WYSIWYG_WIDGET,
                    'settings'  => [],
                ],
                'type'        => BridgeContentType::WYSIWYG_FIELD,
                'settings'    => [],
            ],
            1
        );
    }

    protected function addNewFields(BridgeContentType $bridge): void
    {
        $bridge->contentTypeCreateField(
            'services_presentation',
            'display_button',
            [
                'name' => 'display_button',
                'searchable' => false,
                'translatable' => false,
                'default' => true,
                'search_result_field' => false,
                'required' => false,
                'weight' => 7,
                'title' => [
                    'fr' => 'Afficher le boutton CTA ?'
                ],
                'description' => [
                    'fr' => 'Décochez cette option pour masquer le CTA'
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'group' => 'group_advanced_options',
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            7
        );

        $bridge->contentTypeCreateField(
            'services_presentation',
            'cta_label',
            [
                'name' => 'cta_label',
                'searchable' => true,
                'translatable' => false,
                'default' => 'Lire la suite',
                'search_result_field' => false,
                'required' => false,
                'weight' => 8,
                'title' => [
                    'fr' => 'intitulé du CTA'
                ],
                'description' => [
                    'fr' => ''
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            8
        );
    }

    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();
        $bridge = new BridgeContent();
        $services = ServicesPresentation::query()->where('summary', '!=', null)->get();
        $this->replaceField($bridgeContentType);
        foreach ($services as $service) {
            $summary = $service->summary;
            $bridge->contentUpdate('services_presentation', [
               'uuid' => $service->uuid,
               'summary' => $summary
            ]);
        }
        $this->addNewFields($bridgeContentType);
    }

    public function down(): void
    {
    }
}
