<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class ChangeFolderFieldInServicesSpace extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'services_space', 'procedures_folders');
        $bridge->contentTypeCreateField('services_space', 'info_content', [
            'name' => 'info_content',
            'searchable' => true,
            'translatable' => false,
            'default' => null,
            'global_searchable' => true,
            'required' => true,
            'weight' => 4,
            'title' => [
                'fr' => 'Contenu info à remonter'
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['info_content'],
                'cardinality' => -1,
            ],
        ], 4);
    }

    public function down(): void
    {
    }
}
