<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class DemutualizeFooters extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'services_space',
            'spaces_footer_blocs',
            [
                'name' => 'spaces_footer_blocs',
                'searchable' => false,
                'translatable' => false,
                'default' => null,
                'search_result_field' => false,
                'required' => false,
                'weight' => 17,
                'title' => [
                    'fr' => 'Liens footer'
                ],
                'description' => [
                    'fr' => '',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'group' => 'group_options',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['spaces_footer_blocs'],
                    'cardinality' => -1,
                ],
            ],
            17
        );
    }

    public function down(): void
    {
    }
}
