<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class CreateDepartmentContentType extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('departments');
        $this->finishUp();

        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'departments',
            [
                'name' => 'departments',
                'searchable' => false,
                'translatable' => false,
                'default' => null,
                'search_result_field' => false,
                'required' => false,
                'weight' => 12,
                'title' => [
                    'fr' => 'Département'
                ],
                'description' => [
                    'fr' => '',
                ],
                'widget' => [
                    'hidden' => true,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['departments'],
                    'cardinality' => 1,
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
