<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Inside\Host\Bridge\BridgeContent;

class FixCsvAccounts extends Migration
{
    public function up(): void
    {
        $users = DB::table('inside_users')->where('provider_type', 'csv')->get()->toArray();
        $bridge = new BridgeContent();

        foreach ($users as $user) {
            $bridge->contentUpdate('users', [
                'uuid' => $user->uuid,
                'status' => 0
            ]);
        }
    }

    public function down(): void
    {
    }
}
