<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UnrequireName extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField('users', 'firstname', [
            'name' => 'firstname',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'editable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Prénom',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ], 2);

        $bridge->contentTypeCreateOrUpdateField('users', 'lastname', [
            'name' => 'lastname',
            'type' => BridgeContentType::TEXT_FIELD,
            'editable' => false,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Nom',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ], 3);
    }

    public function down(): void
    {
    }
}
