<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddParamedicFieldToServices extends Migration
{
    public function up(): void
    {
        $bridge = new Inside\Host\Bridge\BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'services',
            'paramedical_contact',
            [
                'name' => 'paramedical_contact',
                'type' => BridgeContentType::TEXT_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 14,
                'title' => [
                    'fr' => 'Coordonnées du personnel paramédical'
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                ],
                'settings' => [
                ]
            ],
            14
        );
    }

    public function down(): void
    {
    }
}
