<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddLinksToProceduresFolders extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'procedures_folders',
            'link',
            [
                'name' => 'link',
                'type' => BridgeContentType::LINK_FIELD,
                'searchable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 4,
                'title' => [
                    'fr' => 'Lien',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [],
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            4
        );
    }

    public function down(): void
    {
    }
}
