<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable' => false,
        'searchable' => true,
        'search_result_field' => true,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'name' => 'services',
        'title' => [
            'fr' => 'Service'
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'type' => BridgeContentType::IMAGE_FIELD,
            'searchable' => false,
            'translatable' => false,
            'editable' => true,
            'search_result_field' => true,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Photo',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => $weight++,
            ],
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'structures',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Site',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => 1,
                'target_type' => ['structure'],
            ],
        ],
        [
            'name' => 'specialties',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Spécialité',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => 1,
                'target_type' => ['specialties'],
            ],
        ],
        [
            'name' => 'email',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Email du service'
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
            ]

        ],
        [
            'name' => 'fax',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Fax'
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
            ]

        ],
        [
            'name' => 'executives',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Cadre',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => -1,
                'target_type' => 'users',
            ],
        ],
        [
            'name' => 'locations',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Emplacements'
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
            ]
        ],
        [
            'name' => 'secretariats',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Secrétariat'
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                ]
        ],
        [
            'name' => 'directions',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Direction/pôle'
                ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [

            ]
        ],
        [
            'name' => 'head_service',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Chef de service',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => -1,
                'target_type' => 'users',
            ],
        ],
        [
            'name' => 'referral_ide',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'IDE Référente',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => 1,
                'target_type' => 'users',
            ],
        ],
        [
            'name' => 'care_stations',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Poste de soins'
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [

            ]
        ],
        [
            'name' => 'nurses',
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Infirmiers (num de tel)'
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => []

        ],
        [
            'name' => 'hospitalizations',
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Hospitalisation (num de tel)'
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                ]

        ],
        [
            'name' => 'consultations',
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Consultations (num de tel)'
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => []
        ],
        [
            'name' => 'internals',
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Internes (num de tel)'
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => []
        ],
        [
            'name' => 'administrative_assistants',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Auxiliaire administrative'
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => []
        ],
        [
            'name' => 'doctor_calls',
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Médecin de garde (num de tel)'
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => []
        ],
        [
            'name' => 'night_executives',
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Cadre de nuit (num de tel)'
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => []
        ],
        [
            'name' => 'medical_advices',
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Avis médical (num de tel)'
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => []
        ],
        [
            'name' => 'programmings',
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Programmation'
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => []
        ],
    ],
];
