<?php

use Illuminate\Support\Str;
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Models\Contents\Users;

function get_entity(array $record, BridgeContent $bridge, string $bundle, string $column): ?array
{
    $name = trim(ucwords(strtolower($record[$column])));

    if (empty($name)) {
        return null;
    }

    $query = call_user_func('Inside\\Content\\Models\\Contents\\'.Str::studly($bundle).'::query');

    $entity = $query->where('title', $name)->first();

    if ($entity) {
        return [$entity->uuid];
    }

    $uuidBridge = $bridge->contentInsert($bundle, [
        'title' => $name,
        'type' => 'node',
        'bundle' => $bundle,
    ]);

    if ($uuidBridge) {
        return [$uuidBridge];
    }

    return null;
}

return [

    /**
     * Apply a post filter on users
     */
    'postfilter' => function ($users) {
        return $users->reject(function ($user) {
            return !Users::query()->where('email', trim($user["email"]))->exists();
        })->toArray();
    },

    'files' => [
        'hpsj' => [
            'path' => __DIR__.'/../../../../imports/annuaire.csv',
            'separator' => ';',
            'fields' => [
                'mail' => function ($record, BridgeContent $bridge) {
                    return trim($record['email']);
                },
                'name' => function ($record, BridgeContent $bridge) {
                    return trim($record['email']);
                },
                'structure' => function ($record, BridgeContent $bridge) {
                    return get_entity($record, $bridge, 'structure', 'site');
                },
                'specialties' => function ($record, BridgeContent $bridge) {
                    return null;
                //return get_entity($record, $bridge, 'specialties', 'specialties');
                },
                'function' => function ($record, BridgeContent $bridge) {
                    return trim($record['fonction']);
                },
                'services' => function ($record, BridgeContent $bridge) {
                    // attention, faire l'import des services avant
                    return get_entity($record, $bridge, 'services', 'service');
                },
                'mobile' => function ($record, BridgeContent $bridge) {
                    return trim($record['téléphone (mobile)']);
                },
                'phone' => function ($record, BridgeContent $bridge) {
                    return trim($record['dect']);
                },
            ],
        ],
    ],
];
