import ClubsPage from '../pages/clubs/ClubsPage'
import ClubsMembersPage from '../pages/clubs/ClubsMembersPage'
import { fetchClubs } from '../components/clubs/clubs'

import ExperiencePage from '../pages/experiences/ExperiencePage'
import { fetchExperience } from '../components/experiences/experience'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import AdminAdvancedSettingsLoginPage from '../pages/advanced-settings/AdminAdvancedSettingsLoginPage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    component: () => import('../pages/news/NewsListingPage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'ClubsListingPage',
    path: '/clubs',
    component: () => import('../pages/clubs/ClubsListingPage')
  },
  {
    name: 'ClubsPage',
    path: '/clubs/:slug',
    component: withFetch(ClubsPage)(fetchClubs)
  },
  {
    name: 'ClubsMembersPage',
    path: '/clubs/:slug/members',
    component: withFetch(ClubsMembersPage)(fetchClubs)
  },
  {
    name: 'ClubsGedPage',
    path: '/clubs/:slug/documents',
    component: () => import('../pages/clubs/ClubsGedPage')
  },
  {
    name: 'ClubsNewsListingPage',
    path: '/clubs/:slug/actualites',
    component: () => import('../pages/clubs/ClubsNewsListingPage')
  },
  {
    name: 'ClubsNewsPage',
    path: '/clubs/:clubs_slug/actualites/:slug',
    component: () => import('../pages/clubs/ClubsNewsPage')
  },
  {
    name: 'BusinessPage',
    path: '/entreprises',
    component: () => import('../pages/business/BusinessPage')
  },
  {
    name: 'JobsPage',
    path: '/offres-d-emploi',
    component: () => import('../pages/jobs/JobsPage')
  },
  {
    name: 'ArchivedJobsPage',
    path: '/archives',
    component: () => import('../pages/jobs/ArchivedJobsPage')
  },
  {
    name: 'ExperiencesPage',
    path: '/experiences',
    component: () => import('../pages/experiences/ExperiencesPage')
  },
  {
    name: 'ExperiencePage',
    path: '/experiences/:slug',
    component: withFetch(ExperiencePage)(fetchExperience)
  },
  {
    name: 'SocialFeedPage',
    path: '/reseaux-sociaux',
    component: () => import('../pages/social-feed/SocialFeedPage')
  },
  {
    name: 'FaqPage',
    path: '/faq',
    component: () => import('../pages/faq/FaqPage')
  },
  {
    name: 'GedPage',
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'ProfileUser',
    component: () => import('../pages/profile/ProfileUserPage')
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  },
  {
    name: 'AdminAdvancedSettingsLoginPage',
    component: withFetch(AdminAdvancedSettingsLoginPage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  },
  {
    name: 'AdminAdvancedSettingsWeatherPage',
    meta: { admin: true, display: true }
  }
]
