import { http } from '@inside-library/helpers/Http'

export default {
  contractTypes: {
    add: () => ({ name: 'JobsPage' }),
    delete: () => ({ name: 'JobsPage' })
  },
  activityDomain: {
    add: () => ({ name: 'JobsPage' }),
    delete: () => ({ name: 'JobsPage' })
  },
  jobs: {
    add: () => ({ name: 'JobsPage' }),
    delete: () => ({ name: 'JobsPage' }),
    globalSearch: ({ vm, data }) => ({
      action: () =>
        vm.triggerModal(
          'job',
          'fetch',
          { item: data, content: data.content_type },
          { layout: 'right', transition: 'fadeInLeft' }
        )
    })
  },
  clubs: {
    add: ({ data }) => ({
      name: 'ClubsPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({ name: 'ClubsListingPage' })
  },
  clubsNews: {
    add: async ({ data }) => {
      const { data: clubs } = await http.get('content/clubs_news', {
        fields: ['uuid', 'slug', { clubs: ['uuid', 'title', 'slug'] }],
        filters: { 'uuid:eq': data.uuid }
      })

      const club = clubs[0].clubs

      return {
        name: 'ClubsNewsPage',
        params: {
          clubs_slug: club.slug[0],
          slug: data.slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: clubs } = await http.get('content/clubs_news', {
        fields: ['uuid', 'slug', { clubs: ['uuid', 'title', 'slug'] }],
        filters: { 'uuid:eq': uuid }
      })

      return {
        name: 'ClubsNewsListingPage',
        params: {
          slug: clubs[0].clubs.slug[0]
        }
      }
    }
  },
  clubsFolders: {
    add: async ({ data }) => {
      const { data: clubs } = await http.get('content/clubs_folders', {
        fields: [
          'uuid',
          'slug',
          { clubs: ['uuid', 'title', 'slug'] },
          {
            clubs_folders: [
              'uuid',
              'title',
              { clubs: ['uuid', 'title', 'slug'] }
            ]
          }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        name: 'ClubsGedPage',
        params: {
          slug:
            clubs[0].clubs_folders?.data[0]?.clubs?.slug[0] ||
            clubs[0].clubs.slug[0]
        },
        query: {
          folder: clubs[0].clubs_folders?.data[0]?.uuid || data.uuid
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: clubs } = await http.get('content/clubs_folders', {
        fields: [
          'uuid',
          'slug',
          { clubs: ['uuid', 'title', 'slug'] },
          {
            clubs_folders: [
              'uuid',
              'title',
              { clubs: ['uuid', 'title', 'slug'] }
            ]
          }
        ],
        filters: { 'uuid:eq': uuid }
      })

      return {
        name: 'ClubsGedPage',
        params: {
          slug:
            clubs[0].clubs_folders?.data[0]?.clubs?.slug[0] ||
            clubs[0].clubs.slug[0]
        }
      }
    }
  },
  clubsDocuments: {
    add: async ({ data }) => {
      const { data: clubs } = await http.get('content/clubs_documents', {
        fields: [
          'uuid',
          'slug',
          {
            clubs_folders: [
              'uuid',
              'title',
              { clubs: ['uuid', 'title', 'slug'] }
            ]
          },
          { clubs: ['uuid', 'title', 'slug'] }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        name: 'ClubsGedPage',
        params: {
          slug:
            clubs[0].clubs_folders?.data[0]?.clubs?.slug[0] ||
            clubs[0].clubs.slug[0]
        },
        query: {
          folder: clubs[0].clubs_folders?.data[0]?.uuid
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: clubs } = await http.get('content/clubs_documents', {
        fields: [
          'uuid',
          'slug',
          {
            clubs_folders: [
              'uuid',
              'title',
              { clubs: ['uuid', 'title', 'slug'] }
            ]
          },
          { clubs: ['uuid', 'title', 'slug'] }
        ],
        filters: { 'uuid:eq': uuid }
      })

      return {
        name: 'ClubsGedPage',
        params: {
          slug:
            clubs[0].clubs_folders?.data[0]?.clubs?.slug[0] ||
            clubs[0].clubs.slug[0]
        },
        query: {
          folder: clubs[0].clubs_folders?.data[0]?.uuid
        }
      }
    }
  },
  business: {
    add: () => ({ name: 'BusinessPage' }),
    delete: () => ({ name: 'BusinessPage' })
  },
  experiences: {
    add: ({ data }) => ({
      name: 'ExperiencePage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({ name: 'ExperiencesPage' })
  }
}
