import { onMounted } from 'vue'
import { getAppInstance } from '@inside-core/helpers/getAppInstance'

import ExperiencesCatalogItem from '../components/experiences/ExperiencesCatalogItem'
import BusinessModal from '../components/modals/BusinessModal'
import BusinessLeaders from '../components/modals/sub-components/BusinessLeaders'
import JobModal from '../components/modals/JobModal'
import WelcomeModal from '../components/modals/WelcomeModal'
import ExperienceModal from '../components/modals/ExperienceModal'

export function useGlobalComponents() {
  const app = getAppInstance()

  onMounted(() => {
    app.component('experiences-catalog-item', ExperiencesCatalogItem)
    app.component('business-modal', BusinessModal)
    app.component('business-leaders', BusinessLeaders)
    app.component('job-modal', JobModal)
    app.component('welcome-modal', WelcomeModal)
    app.component('experience-modal', ExperienceModal)
  })
}
