import { http } from '@inside-library/helpers/Http'

const fetchWeather = async () => {
  try {
    const { data } = await http.get('content/weather_cities', {
      fields: [
        'uuid',
        'title',
        'published_at',
        'country',
        'admin',
        'content_type',
        'weight'
      ],
      filters: {
        'status:eq': 1,
        sort: 'weight:asc'
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

const fetchCommunication = async () => {
  try {
    const { data } = await http.get('content/communication_block', {
      fields: [
        'uuid',
        'title',
        'published_at',
        'image',
        'link',
        'link_title',
        'body',
        'admin',
        'content_type'
      ],
      filters: {
        'status:eq': 1,
        sort: 'published_at:desc'
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

const fetchSocialBlock = async () => {
  try {
    const { data } = await http.get('content/social_cards_links', {
      fields: [
        'uuid',
        'title',
        'image',
        'link',
        'published_at',
        'content_type',
        'admin'
      ],
      filters: { 'status:eq': 1, sort: 'published_at:desc', limit: 1 }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchWeather, fetchCommunication, fetchSocialBlock }
