import { http } from '@inside-library/helpers/Http'

export const fetchClubs = async ({ $route }) => {
  try {
    const { data } = await http.get('content/clubs', {
      fields: [
        'uuid',
        'title',
        'published_at',
        'admin',
        'content_type',
        'body',
        'content',
        {
          users: [
            'uuid',
            'firstname',
            'lastname',
            'image',
            {
              business: ['title', 'uuid']
            },
            'function'
          ]
        }
      ],

      filters: {
        'status:eq': 1,
        'slug:eq': $route.params.slug
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}
