export default {
  business: {
    modalFields: [
      'title',
      'uuid',
      'content',
      'site_link',
      'image',
      'housing',
      'housed_people',
      'coworker',
      {
        leaders: ['uuid', 'firstname', 'lastname', 'email', 'function', 'image']
      }
    ]
  },
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      {
        authors: ['lastname', 'firstname', 'email']
      },
      { folders: ['title'] },
      'content',
      'body',
      'content_type',
      'published_at',
      'file',
      'langcode',
      'pid',
      'status',
      'title',
      'updated_at',
      'uuid',
      'uuid_host',
      {
        reactions: [
          'count',
          {
            users: ['uuid']
          }
        ]
      }
    ]
  },
  clubs_documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      {
        authors: ['lastname', 'firstname', 'email']
      },
      { folders: ['title'] },
      'content',
      'body',
      'content_type',
      'published_at',
      'file',
      'pid',
      'status',
      'title',
      'updated_at',
      'uuid',
      {
        clubs_folders: ['uuid', 'title']
      }
    ]
  },
  jobs: {
    extendedUrl: ['uuid'],
    modalFields: [
      'title',
      'content',
      'business',
      'region',
      'contact',
      'uuid',
      'slug',
      'content_type',
      'published_at',
      'email',
      'status',
      'date',
      'langcode',
      'uuid',
      'profile',
      'link',
      'service_text',
      'city',
      { contract_types: ['uuid', 'title'] },
      { activity_domain: ['uuid', 'title'] },
      { authors: ['uuid', 'lastname', 'firstname'] }
    ]
  },
  modal: {
    modalFields: ['class', 'content']
  },
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'email',
      'function',
      'activity_domain',
      'status',
      'firstname',
      'address',
      'uuid',
      'hobby',
      'linkedin',
      'twitter',
      'lastname',
      'image',
      'service',
      'phone',
      'mobile_phone',
      'uuid',
      'mini_bio',
      { locations: ['title', 'uuid'] },
      { sites: ['title', 'uuid', 'slug'] },
      { users: ['firstname', 'lastname', 'uuid', 'function', 'image'] },
      { business: ['image', 'title', 'intranet'] },
      {
        experiences: {
          fields: ['title', 'uuid', 'slug'],
          filters: { reverse: true }
        }
      }
    ]
  },
  custom: {
    modalFields: ['uuid', 'content', 'content_type']
  },
  experiences: {
    modalFields: ['uuid', 'slug'],
    messages: {
      create: 'Le projet a bien été soumis'
    },
    editionTitle: 'Intitulé de votre expérience'
  },
  experiences_documents: {
    modalFields: [
      {
        authors: ['lastname', 'firstname', 'email']
      },
      { folders: ['title'] },
      'content',
      'body',
      'content_type',
      'published_at',
      'file',
      'langcode',
      'pid',
      'status',
      'title',
      'updated_at',
      'uuid',
      'uuid_host',
      {
        reactions: [
          'count',
          {
            users: ['uuid']
          }
        ]
      }
    ]
  }
}
