export default {
  'inside-archives': {
    isEnabled: true
  },
  'inside-customs': {
    templates: {
      fullContent: {
        clubsNews: {
          mainComponent: () => import('@inside-news/components/lib/Full'),
          relatedComponent: () => import('@inside-news/components/lib/Minimal')
        }
      }
    }
  },
  'inside-events': {
    rootRoute: {
      fr: 'agenda'
    }
  },
  'inside-news': {
    bookmarkEnabled: false,
    commentsEnabled: true,
    e2e: {
      feedContents: ['news', 'clubs_news'],
      newsCategoriesContent: 'news_categories'
    }
  },
  'inside-users': {
    extraComponent: {
      'login-form': 'components/login/LoginExtraComponentCustoms'
    },
    shortcuts: {
      max: 4
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    },
    csvImport: true,
    extraFields: [
      { business: ['intranet_link', 'intranet_link_title', 'uuid'] }
    ]
  },
  'inside-edition': {
    descriptionAsTooltip: false
  },
  'inside-ged': {
    rootRoute: {
      fr: 'ressources-communes'
    }
  },
  'inside-jobs': {
    mainContentType: 'jobs',
    extraFields: ['published_at'],
    categoriesFields: ['business']
  },
  'inside-workflows': {
    isEnabled: true
  }
}
