import { http } from '@inside-library/helpers/Http'

export const fetchExperience = async ({ $route }) => {
  try {
    const { data } = await http.get('content/experiences', {
      fields: [
        'subtitle',
        {
          experience_types: ['title']
        },
        'published_at',
        'updated_at',
        'title',
        'content_type',
        'admin',
        'slug',
        'uuid',
        {
          year: ['title']
        },
        {
          experience_categories: ['title']
        },
        {
          business: ['title']
        },
        'keywords',
        'file',
        'content',
        {
          referents: [
            'uuid',
            'phone',
            'content_type',
            'lastname',
            'firstname',
            {
              business: ['title']
            },
            'email',
            'count',
            'image',
            {
              experiences: ['title', 'uuid', 'slug']
            }
          ]
        },
        'partners',
        'objectives',
        'review_and_perspectives',
        'context',
        'action',
        'success_conditions'
      ],
      filters: {
        'status:eq': 1,
        'slug:eq': $route.params.slug
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}
