<?php

namespace Inside\HARE\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

/**
 * Change job notifications URLs
 *
 * @category Class
 * @package  Inside\HARE\Http\Middleware\NotificationsMiddleware
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class NotificationsMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param \Illuminate\Http\Request $request
     * @param \Closure $next
     *
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $currentPath = $request->path();

        if (strpos($currentPath, 'api/v1/notifications') !== 0) {
            return $next($request);
        }

        $response = $next($request);

        $content = $response->getContent();

        $content = json_decode($content, true);

        if (!array_key_exists('data', $content)) {
            return $response;
        }
        foreach ($content['data'] as $key => &$data) {
            if ($data['text'] !== 'notifications.create.jobs') {
                continue;
            }

            $data['url'] = '/offres-d-emploi#&modal/jobs/' . $data['model']['uuid'];
        }

        $response->setContent(json_encode($content));

        return $response;
    }
}
