<?php

namespace Inside\HARE\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Inside\Content\Facades\ContentHelper;
use Inside\Content\Models\Contents\Users;
use Inside\Content\Models\Contents\Jobs;
use Inside\Content\Transformers\ContentTransformer;
use Inside\Permission\Facades\Permission;
use Inside\Support\Stringable;
use Laravel\Lumen\Routing\Controller;
use Symfony\Component\HttpFoundation\Response;

class KeepeekController extends Controller
{
    public function getUser(Request $request, string $uuid): JsonResponse
    {
        $data = Permission::withoutAllowedScope(function () use ($uuid) {
            $user = Users::findOrFail($uuid);
            $transformer = new ContentTransformer();

            $attributes = ['email', 'function', 'updated_at', 'activity_domain', 'status', 'firstname', 'uuid', 'lastname',
                'service', 'phone', 'mobile_phone', 'locations' => ['title'], 'business' => ['title']];
            $data = [];
            $transformer->transform($user, $attributes, $data);
            return $data;
        });

        return new JsonResponse(['data' => $data], 200);
    }

    public function getUserImage(Request $request, string $uuid): ?string
    {
        $user = Users::withoutGlobalScopes()->findOrFail($uuid);
        $imagePath = $user->image;
        if (!$imagePath || !Storage::exists($imagePath)) {
            return null;
        }

        return $this->getFileFromStorage($imagePath);
    }

    public function getResource(Request $request, string $path): Response | JsonResponse
    {
        preg_match('/\/file\/(\d{4}-\d{2}).*/', $path, $matches);
        $filePath = preg_replace('/\/file/', '', $matches[0]);
        if (!Storage::exists($filePath)) {
            return new JsonResponse(['message' => 'File not found !'], 404);
        }

        return $this->getFileFromStorage($filePath);
    }

    public function getJobDetails(Request $request, string $uuid): JsonResponse
    {
        $data = Permission::withoutAllowedScope(function () use ($uuid) {
            $user = Jobs::findOrFail($uuid);
            $transformer = new ContentTransformer();

            $attributes = ['title', 'activity_domain' => ['title'], 'content' => ['path'], 'email', 'business', 'link', 'profil', 'region',
                'service_text', 'contract_types', 'city', 'published_at'];
            $data = [];
            $transformer->transform($user, $attributes, $data);
            return $data;
        });

        return new JsonResponse(['data' => $data], 200);
    }

    private function getFileFromStorage(string $filePath): Response
    {
        $path = Storage::path($filePath);
        /** @var string $file */
        $file = file_get_contents($path);
        /** @var array $pathinfo */
        $pathinfo = pathinfo($path);
        $extension = $pathinfo['extension'];

        switch ($extension) {
            case "gif":
                $type = "image/gif";
                break;
            case "png":
                $type = "image/png";
                break;
            case "jpeg":
            case "jpg":
                $type = "image/jpeg";
                break;
            case "mp4":
                $type = "video/mp4";
                break;
            case "pdf":
                $type = "application/pdf";
                break;
            default:
                return new JsonResponse(['message' => 'File not found !'], 404);
        }

        return new Response($file, 200, ['Content-type' => $type]);
    }
}
