<?php

namespace Inside\HARE\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Laravel\Lumen\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Inside\Content\Models\Contents\SocialFeedAccount;
use Inside\Content\Models\Contents\News;
use Illuminate\Support\Facades\Storage;

/**
 * Inside feed controller.
 *
 * @category Class
 */
class FeedController extends Controller
{
    public function rss(Request $request): ?Response
    {
        if (!Auth::user()) {
            return null;
        }

        // News
        $newses = News::where('status', 1)->limit(100)->get();

        // Base url
        $baseUrl = config('app.url');

        // Generate RSS feed
        $xml = new \XMLWriter();
        $xml->openMemory();
        $xml->startDocument('1.0', 'utf-8');
        $xml->startElement('rss');
        $xml->writeAttribute('version', '2.0');
        $xml->startElement('channel');
        $xml->writeElement('title', env('APP_NAME'));
        $xml->writeElement('description', env('APP_NAME'));
        $xml->writeElement('lastBuildDate', date('D, d M Y H:i:s T'));
        $xml->writeElement('link', $baseUrl);

        // News
        foreach ($newses as $news) {
            $author = $news->authors()->first();

            $xml->startElement('item');
            $xml->writeElement('title', $news->title);
            $xml->startElement('description');
            $xml->writeCdata($news->chapo);
            $xml->endElement();
            $xml->writeElement('pubDate', date('D, d M Y H:i:s T', $news->updated_at));
            $xml->writeElement('link', $baseUrl . '/' . implode('/', $news->slug));
            $xml->writeElement('author', $author ? $author->email : 'Anonymous');
            $xml->writeElement('guid', $news->uuid);
            foreach ($news->newsCategories as $cat) {
                $xml->writeElement('category', $cat->title);
            }

            if (!empty($news->image)) {
                $xml->startElement('enclosure');
                $xml->writeAttribute('url', $baseUrl.Storage::url($news->image));
                try {
                    $size = Storage::size($news->image);
                    $xml->writeAttribute('length', "$size");
                } catch (\Exception $ex) {
                }
                $xml->writeAttribute('type', 'image/'.substr($news->image, strrpos($news->image, '.') + 1));
                $xml->endElement();
            }

            $xml->endElement();
        }
        $xml->endElement();
        $xml->endElement();

        /** @var Response $response */
        $response = response($xml->outputMemory(), 200);
        $response->header('Content-Type', 'application/xml');

        return $response;
    }

    public function social(Request $request): array
    {
        date_default_timezone_set('UTC');

        $res = DB::table('inside_socials');

        // GET[max_date] as timestamp php
        if ($request->has('max_date')) {
            /** @var string $maxDate */
            $maxDate = $request->input('max_date');
            $res->where('date', '<=', date('Y-m-d H:i:s', (int)$maxDate));
        }

        // GET[limit] as integer
        if ($request->has('limit')) {
            $res->limit($request->input('limit'));
        }

        // Fetch + convert date
        $feeds = $res->orderBy('date', 'DESC')->get()->map(function ($feed) {
            $feed->date = strtotime($feed->date);
            return $feed;
        });

        return [
            'feeds' => $feeds,
            'accounts' => SocialFeedAccount::get(),
        ];
    }
}
