<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Layout\Models\LayoutPath;
use Inside\Layout\Models\Layout;

class SeedCustomPages extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();
        collect([
            ['title' => 'Les clubs', 'custom_slug' => 'clubs-listing', 'redirection_page' => 'ClubsListingPage'],
            ['title' => 'Entreprises', 'custom_slug' => 'business', 'redirection_page' => 'BusinessPage'],
            ['title' => 'Offres d\'emploi', 'custom_slug' => 'jobs', 'redirection_page' => 'JobsPage'],
            ['title' => 'Archives', 'custom_slug' => 'archived-jobs', 'redirection_page' => 'ArchivedJobsPage'],
            ['title' => 'Réseaux sociaux', 'custom_slug' => 'social-feed', 'redirection_page' => 'SocialFeedPage'],
            ['title' => 'FAQ', 'custom_slug' => 'faq', 'redirection_page' => 'FaqPage'],
            ['title' => 'Bibliothèque', 'custom_slug' => 'ged', 'redirection_page' => 'GedPage'],
            ['title' => 'Annuaire', 'custom_slug' => 'directory', 'redirection_page' => 'DirectoryPage'],
        ])->each(fn ($custom) => $bridge->contentInsert(type: 'custom', data: $custom, fromCli: true));

        LayoutPath::with('layout')
            ->where('path', 'not like', 'inside_content_forms.%')
            ->get()
            ->pluck('layout')
            ->each(fn (Layout $layout) => $layout->delete());

        $bridge = new BridgeContentType();

        $bridge->updateFieldOptions('experiences', 'image', [
           'search_result_field' => true,
        ]);

        $bridge->updateFieldOptions('experience_categories', 'image', [
            'search_result_field' => true,
        ]);
    }
}
