<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

class FixUsers extends Migration
{
    public function up(): void
    {
        DB::table('inside_users')->update([
            'provider_type' => 'csv',
            'provider_name' => 'hare'
        ]);

        $bridge = new BridgeContent();

        Users::each(function ($user) use ($bridge) {
            if (trim($user->email) !== $user->email) {
                $bridge->contentUpdate('users', [
                    'uuid' => $user->uuid,
                    'mail' => trim($user->email)
                ]);
            }
        });
    }


    public function down(): void
    {
    }
}
