<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Archive\Services\ArchiveService;
use Inside\Content\Models\Contents\Jobs;
use Illuminate\Support\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class PrepareJobsForArchives extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $jobs = Jobs::query()->where('status', 0)->get();
        $service = new ArchiveService();
        foreach ($jobs as $job) {
            $service->archiveContent((string) get_class($job), $job->uuid, strtotime($job->end_at), true);
        }
        $bridge = new BridgeContentType();
        $bridge->contentTypeDeleteField('node', 'jobs', 'end_at');
    }
}
