<?php

return [
    'inside_external_api_enabled' => env('INSIDE_EXTERNAL_API_ENABLED', true),
    'inside_external_api_bypass_auth_external' => env('INSIDE_EXTERNAL_API_AUTH_BYPASS', true),
    'inside_external_api_pagination_limit' => 50,
    'inside_external_api_fields' => [
        'users' => [
            'email',
            'uuid',
            'status',
            'updated_at'
        ],
        'jobs' => [
            'uuid',
            'title',
            'activity_domain',
            'content',
            'email',
            'business',
            'link',
            'profil',
            'region',
            'service_text',
            'contract_types',
            'city',
            'published_at',
        ],
    ],
    'inside_external_api_filters' => function ($query, $request) {
        $query->where('status', '=', true);
        if ($request->has('updated_at')) {
            $timestamp = $request->get('updated_at');
            $query->where('updated_at', '>=', date('Y-m-d H:i:s', $timestamp));
        }
        return $query;
    }
];
