<?php

use Illuminate\Support\Facades\Route;
use Inside\Content\Facades\Schema;
use Inside\Content\Http\Controllers\External\Index as ExternalIndex;

Route::group(
    [
        'namespace'  => 'Inside\HARE\Http\Controllers',
        'prefix'     => 'api/v1',
        'middleware' => 'auth.api',
    ],
    function ($router) {
        $router->get('feed/social', ['uses' => 'FeedController@social']);
        $router->get(
            '/experiences/pdf/{id}',
            ['as' => 'experience.pdf', 'uses' => 'ExperienceController@experiencePdf']
        );
    }
);

Route::group(
    [
        'namespace' => 'Inside\HARE\Http\Controllers',
    ],
    function ($router) {
        $router->get('feed/rss', ['uses' => 'FeedController@rss']);
    }
);

Route::group(
    [
        'namespace' => 'Inside\HARE\Http\Controllers',
        'prefix' => 'api/v1',
        'middleware' => ['auth.external:keepeek'],
    ],
    function ($router) {
        $router->get('external/user/{uuid}', ['uses' => 'KeepeekController@getUser']);
        $router->get('external/user/picture/{uuid}', ['uses' => 'KeepeekController@getUserImage']);
        $router->get('external/jobs/{uuid}', ['uses' => 'KeepeekController@getJobDetails']);
        $router->get('external/resource/{path:.*}', ['uses' => 'KeepeekController@getResource']);
    }
);

Route::group(
    [
        'prefix' => 'api/v1',
        'middleware' => ['auth.external:keepeek'],
    ],
    function ($router) {
        $router->get('external/{type:'.get_authorized_external_api_content_types().'}', ExternalIndex::class);
    }
);
