<?php

namespace Inside\HARE\Providers;

use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Lang;
use Inside\Content\Events\ContentInsertedEvent;
use Inside\Content\Events\ContentUpdatedEvent;
use Inside\HARE\Console\CleanReferences;
use Inside\HARE\Http\Middleware\NotificationsMiddleware;
use Inside\HARE\Listeners\ContentInsertedListener;
use Inside\HARE\Listeners\ContentUpdatedListener;
use Inside\Providers\ServiceProvider as BaseServiceProvider;
use Inside\HARE\Http\Middleware\WeatherData;
use Inside\HARE\Console\ImportSocialFeed;

class ServiceProvider extends BaseServiceProvider
{
    /**
     * @var string[][]
     */
    protected $listen = [
        ContentInsertedEvent::class => [
            ContentInsertedListener::class
        ],
        ContentUpdatedEvent::class => [
            ContentUpdatedListener::class
        ]
    ];

    /**
     * {@inheritDoc}
     */
    public function boot(): void
    {
        // Database migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        foreach ($this->listen as $event => $listeners) {
            foreach ($listeners as $listener) {
                Event::listen($event, $listener);
            }
        }
    }

    /**
     * {@inheritDoc}
     */
    public function register(): void
    {
        // Middlewares
        if (method_exists($this->app, 'middleware')) {
            $this->app->middleware([
                NotificationsMiddleware::class,
                WeatherData::class,
            ]);
        }


        $this->app->register(\Barryvdh\DomPDF\ServiceProvider::class);

        $this->app->alias('PDF', \Barryvdh\DomPDF\Facade::class);

        $this->mergeConfigFrom(__DIR__ . '/../../config/csv.php', 'csv');
        $this->mergeConfigFrom(__DIR__ . '/../../config/xlsx.php', 'xlsx');

        // Cron jobs
        $this->mergeRecursiveConfigFrom(__DIR__ . '/../../config/scheduler.php', 'scheduler');
        $this->mergeRecursiveConfigFrom(__DIR__ . '/../../config/app.php', 'app');
        $this->mergeConfigTo(__DIR__. '/../../config/archive.php', 'archive');
        $this->mergeConfigTo(__DIR__.'/../../config/external_api.php', 'external_api');

        // Clean sites command singleton
        $this->app->singleton('command.hare.cleanreferences', function ($app) {
            return new CleanReferences();
        });

        // Clean sites command singleton
        $this->app->singleton('command.hare.importsocialfeed', function ($app) {
            return new ImportSocialFeed();
        });

        // Command lines
        $this->commands([
            'command.hare.cleanreferences',
            'command.hare.importsocialfeed',
        ]);
    }
}
