<?php

namespace Inside\HARE\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Events\ContentUpdatedEvent;
use Inside\HARE\Jobs\GeneratePdf;

class ContentUpdatedListener implements ShouldQueue
{
    public function handle(ContentUpdatedEvent $event): void
    {
        $model = $event->model;
        if ($model->content_type == "experiences") {
            GeneratePdf::dispatch($model->uuid, true)->onQueue(get_low_priority_queue_name());
        }
    }
}
