<?php

namespace Inside\HARE\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Events\ContentInsertedEvent;
use Inside\HARE\Jobs\GeneratePdf;

class ContentInsertedListener implements ShouldQueue
{
    public function handle(ContentInsertedEvent $event): void
    {
        $model = $event->model;

        if ($model->content_type == "experiences") {
            GeneratePdf::dispatch($model->uuid, true)->onQueue(get_low_priority_queue_name());
        }
    }
}
