<?php

namespace Inside\HARE\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\SerializesModels;
use Inside\Content\Models\Contents\Experiences;
use Inside\HARE\Services\PdfService;
use Inside\Jobs\Job;

/**
 * Class GeneratePdf
 *
 * @category Class
 * @package  Inside\HARE\Jobs\GeneratePdf
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class GeneratePdf extends Job
{
    /**
     * @var string
     */
    protected $uuid;

    /**
     * @var bool
     */
    protected $update;

    /**
     * @var PdfService
     */
    protected $pdfService;

    public function __construct(string $uuid, bool $update = false)
    {
        $this->uuid = $uuid;
        $this->update = $update;
        $this->pdfService = new PdfService();
    }

    public function handle(): void
    {
        $experience = Experiences::find($this->uuid);
        if ($experience) {
            $this->pdfService->generatePdf($experience, $this->update);
        }
        $this->delete();
    }
}
