<?php

namespace Inside\HARE\Console;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Inside\Content\Models\Contents\ActivityDomain;
use Inside\Host\Bridge\BridgeContent;

class CleanReferences extends Command
{
    /**
     * @var string
     */
    protected $name = 'hare:cleanreferences';

    /*
     * @var string
     */
    protected $signature = 'hare:cleanreferences';

    /**
     * @var string
     */
    protected $description = 'Clean HARE references';

    public function handle(): void
    {
        $activityDomains = ActivityDomain::all();
        $bridge = new BridgeContent();

        foreach ($activityDomains as $activityDomain) {
            $pivots = DB::table('inside_pivots')
                ->where('related_uuid', $activityDomain->uuid)
                ->get();

            if ($pivots->count() > 0) {
                continue;
            }

            $this->info(sprintf('Deleting site %s [uuid: %s]', $activityDomain->title, $activityDomain->uuid));
            $bridge->contentDelete('activity_domain', $activityDomain->uuid);
        }
    }
}
