<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 0;

return [
    'options' => [
        'name' => 'image_galery',
        'title' => [
            'fr' => 'Image galerie',
        ],
    ],
    'fields' => [
        [
            'name' => 'title',
            'searchable' => false,
            'translatable' => false,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight++,
            'title' => [
                'fr' => 'Titre',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => false,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 6,
            'title' => [
                'fr' => 'Image',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 6,
                'group' => 'group_advanced_options',
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
